/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.utils;

import com.flemmli97.improvedmobs.config.Config;
import com.google.common.collect.AbstractIterator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;

public class CustomBlockCollision
extends AbstractIterator<VoxelShape> {
    private final AxisAlignedBB box;
    private final ISelectionContext context;
    private final CubeCoordinateIterator cursor;
    private final BlockPos.Mutable pos;
    private final VoxelShape entityShape;
    private final ICollisionReader collisionGetter;
    private IBlockReader cachedBlockGetter;
    private long cachedBlockGetterPos;

    public CustomBlockCollision(ICollisionReader reader, @Nullable Entity entity, AxisAlignedBB aABB) {
        this.context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        this.pos = new BlockPos.Mutable();
        this.entityShape = VoxelShapes.func_197881_a((AxisAlignedBB)aABB);
        this.collisionGetter = reader;
        this.box = aABB;
        int i = MathHelper.func_76128_c((double)(aABB.field_72340_a - 1.0E-7)) - 1;
        int j = MathHelper.func_76128_c((double)(aABB.field_72336_d + 1.0E-7)) + 1;
        int k = MathHelper.func_76128_c((double)(aABB.field_72338_b - 1.0E-7)) - 1;
        int l = MathHelper.func_76128_c((double)(aABB.field_72337_e + 1.0E-7)) + 1;
        int m = MathHelper.func_76128_c((double)(aABB.field_72339_c - 1.0E-7)) - 1;
        int n = MathHelper.func_76128_c((double)(aABB.field_72334_f + 1.0E-7)) + 1;
        this.cursor = new CubeCoordinateIterator(i, k, m, j, l, n);
    }

    @Nullable
    private IBlockReader getChunk(int i, int j) {
        IBlockReader blockGetter;
        int k = i >> 4;
        int l = j >> 4;
        long m = ChunkPos.func_77272_a((int)k, (int)l);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == m) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = blockGetter = this.collisionGetter.func_225522_c_(k, l);
        this.cachedBlockGetterPos = m;
        return blockGetter;
    }

    protected VoxelShape computeNext() {
        while (this.cursor.func_218301_a()) {
            IBlockReader blockGetter;
            int i = this.cursor.func_218304_b();
            int j = this.cursor.func_218302_c();
            int k = this.cursor.func_218303_d();
            int l = this.cursor.func_223473_e();
            if (l == 3 || (blockGetter = this.getChunk(i, k)) == null) continue;
            this.pos.func_181079_c(i, j, k);
            BlockState blockState = blockGetter.func_180495_p((BlockPos)this.pos);
            if (Config.CommonConfig.breakableBlocks.canBreak(blockState, (BlockPos)this.pos, blockGetter, this.context) || l == 1 && !blockState.func_215704_f() || l == 2 && !blockState.func_203425_a(Blocks.field_196603_bb)) continue;
            VoxelShape voxelShape = blockState.func_215685_b((IBlockReader)this.collisionGetter, (BlockPos)this.pos, this.context);
            if (voxelShape == VoxelShapes.func_197868_b()) {
                if (!this.box.func_186668_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)) continue;
                return voxelShape.func_197751_a((double)i, (double)j, (double)k);
            }
            VoxelShape voxelShape2 = voxelShape.func_197751_a((double)i, (double)j, (double)k);
            if (!VoxelShapes.func_197879_c((VoxelShape)voxelShape2, (VoxelShape)this.entityShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            return voxelShape2;
        }
        return (VoxelShape)this.endOfData();
    }
}

